/**
 * 
 */
package gov.va.med.mhv.usermgmt.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.atlas.service.BooleanServiceResponse;

import gov.va.med.mhv.usermgmt.service.UserProfileTestCase;
import gov.va.med.mhv.usermgmt.transfer.Patient;

/**
 * @author Rob Proper (Aquilent Inc.)
 *
 */
public class PHRAccessControlTest extends UserProfileTestCase {
    /* 
     * Provide the name of a test user in the system property specified
     * in static variable PROPERTY. 
     * Assign access cntrols to this user to test certain conditions
     * NOTE Only certain tests will succeed depending on the assigned
     * access controls
     */
    
    private static final Log LOG = LogFactory.getLog(PHRAccessControlTest.
        class);

    public static final String PROPERTY = "phrAccessControlTest.userName";
    

    /*
     * Test method for 'gov.va.med.mhv.usermgmt.util.PHRAccessControl.
     * hasPhrAccess(Patient)'
     */
    public void testPatientWithNoAcccess() {
        if (!hasStagedPatientName("testPatientWithNoAcccess")) {
            return;
        }
        Patient patient = getStagedPatient();
        BooleanServiceResponse response = PHRAccessControl.hasPhrAccess(
            patient);
        assertNotNull(response);
        assertNotNull(response.getBoolean());
        assertFalse(response.getBoolean());
    }

    public void testPatientWithAcccess() {
        if (!hasStagedPatientName("testPatientWithAcccess")) {
            return;
        }
        Patient patient = getStagedPatient();
        BooleanServiceResponse response = PHRAccessControl.hasPhrAccess(
            patient);
        assertNotNull(response);
        assertNotNull(response.getBoolean());
        assertTrue(response.getBoolean());
    }


/*
     * Test method for 'gov.va.med.mhv.usermgmt.util.PHRAccessControl.
     * hasPhrAccess(String)'
     */
    public void testWithUserNameAndNoAccess() {
        if (!hasStagedPatientName("testWithUserNameAndNoAccess")) {
            return;
        }
        Patient patient = getStagedPatient();
        BooleanServiceResponse response = PHRAccessControl.hasPhrAccess(
            patient.getUserProfile().getUserName());
        assertNotNull(response);
        assertNotNull(response.getBoolean());
        assertFalse(response.getBoolean());
    }

    public void testWithUserNameAndAccess() {
        if (!hasStagedPatientName("testWithUserNameAndAccess")) {
            return;
        }
        Patient patient = getStagedPatient();
        BooleanServiceResponse response = PHRAccessControl.hasPhrAccess(
            patient.getUserProfile().getUserName());
        assertNotNull(response);
        assertNotNull(response.getBoolean());
        assertTrue(response.getBoolean());
    }

    /*
     * Test method for 'gov.va.med.mhv.usermgmt.util.PHRAccessControl.
     * hasPhrAccess(ExtractType, Patient)'
     */
    public void testExtractTypeAndPatientWithNoAccess() {
        if (!hasStagedPatientName("testExtractTypeAndPatientWithNoAccess")) {
            return;
        }
        Patient patient = getStagedPatient();
        BooleanServiceResponse response = PHRAccessControl.hasPhrAccess(
            ExtractTypeUtils.CHEMISTRYHEMATOLOGY, patient);
        assertNotNull(response);
        assertNotNull(response.getBoolean());
        assertFalse(response.getBoolean());
    }

    public void testExtractTypeAndPatientWithChemistryAccess() {
        if (!hasStagedPatientName("testExtractTypeAndPatientWithChemistryAccess")) {
            return;
        }
        Patient patient = getStagedPatient();
        BooleanServiceResponse response = PHRAccessControl.hasPhrAccess(
            ExtractTypeUtils.CHEMISTRYHEMATOLOGY, patient);
        assertNotNull(response);
        assertNotNull(response.getBoolean());
        assertTrue(response.getBoolean());
    }

    protected Log getLocalLog() {
        return LOG;
    }

    protected String getStagedPatientNameProperty() {
        return PROPERTY;
    }

}
